﻿/*  Author:     Ben Hall
 *  File:       Weapon.cs
 *  Date:       4/28/2011
 *  
 *  Purpose:    Weapon.cs extends the Equipment class and is used to represent Equipment
 *              that changes the damage values of a PlayerCharacter.  Weapons may be two-handed,
 *              which prevents the PlayerCharacter from wielding them at the same time they
 *              use a Shield.
 *              
 *              This class only contains a constructor and get methods for its variables.
 */

using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

namespace OnlineGame
{
    public class Weapon : Equipment
    {
        private int minDamage;
        private int maxDamage;
        private bool twoHanded;

        public Weapon(String weaponNameIn, int weaponValueIn, int minDamageIn, int maxDamageIn, bool twoHandedIn)
        {
            this.itemName = weaponNameIn;
            this.itemValue = weaponValueIn;
            this.minDamage = minDamageIn;
            this.maxDamage = maxDamageIn;
            this.twoHanded = twoHandedIn;
        }

        public int GetWeaponMaxDamage()
        {
            return this.maxDamage;
        }

        public int GetWeaponMinDamage()
        {
            return this.minDamage;
        }

        public bool IsTwoHanded()
        {
            return this.twoHanded;
        }
    }
}
